<?php

declare(strict_types=1);

namespace Samba\M2Integration\Plugin;

class DisableSnapshotPlugin
{
    private static $DISABLE_SNAPSHOT = false;

    public function aroundRegisterSnapshot(
        \Magento\Framework\Model\ResourceModel\Db\VersionControl\Snapshot $subject,
        callable $proceed,
        \Magento\Framework\DataObject $entity
    ) {
        if (!self::$DISABLE_SNAPSHOT) {
            return $proceed($entity);
        }
    }

    public static function disable(): void
    {
        self::$DISABLE_SNAPSHOT = true;
    }

    public static function enable(): void
    {
        self::$DISABLE_SNAPSHOT = false;
    }
}
