<?php
namespace Samba\M2Integration\Observer;

use Samba\M2Integration\Model\QueueManager;
use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;

class ProcessConfig implements ObserverInterface
{
    /**
     * @var QueueManager
     */
    private $queueManager;

    public function __construct(
        QueueManager $queueManager,
    ) {
        $this->queueManager = $queueManager;
    }

    public function execute(Observer $observer): void
    {
        $shouldGenerateProducts = false;
        $shouldGenerateCustomers = false;
        $shouldGenerateOrders = false;

        foreach ($observer->getChangedPaths() as $path) {
            if (!$shouldGenerateProducts && str_starts_with($path, 'samba_config/products')) {
                $shouldGenerateProducts = true;
                continue;
            }

            if (!$shouldGenerateCustomers && str_starts_with($path, 'samba_config/customers')) {
                $shouldGenerateCustomers = true;
                continue;
            }

            if (!$shouldGenerateOrders && str_starts_with($path, 'samba_config/orders')) {
                $shouldGenerateOrders = true;
                continue;
            }
        }

        if ($shouldGenerateProducts) {
            $this->queueManager->enqueue('products');
        }

        if ($shouldGenerateCustomers) {
            $this->queueManager->enqueue('customers');
        }

        if ($shouldGenerateOrders) {
            $this->queueManager->enqueue('orders');
        }
    }
}
