<?php

declare(strict_types=1);

namespace Samba\M2Integration\Observer;

use Magento\Sales\Api\OrderRepositoryInterface;
use Samba\M2Integration\Helper\DataHelper;
use Magento\Framework\Event\Observer as EventObserver;
use Magento\Framework\Event\ObserverInterface;

class OrderSuccessPageViewObserver implements ObserverInterface
{
    /** @var DataHelper */
    protected $dataHelper;

    /** @var OrderRepositoryInterface */
    protected $orderRepository;

    /**
     * @param DataHelper $dataHelper
     * @param OrderRepositoryInterface $orderRepository
     */
    public function __construct(
        DataHelper $dataHelper,
        OrderRepositoryInterface $orderRepository
    ) {
        $this->dataHelper = $dataHelper;
        $this->orderRepository = $orderRepository;
    }

    /**
     * @param EventObserver $observer
     * @return void
     */
    public function execute(EventObserver $observer): void
    {
        $data = [];

        $orderIds = $observer->getEvent()->getOrderIds();
        $orderId = $orderIds[0];
        $order = $this->orderRepository->get($orderId);

        foreach ($order->getAllVisibleItems() as $item) {
            $data[] = (object)[
                "productId" => $item->getProductId(),
                "price" => $item->getPrice() * (int)$item->getQtyOrdered()
            ];
        }

        $this->dataHelper->getSessionCheckoutManager()->setOrderData($data);
    }
}
