<?php

declare(strict_types=1);

namespace Samba\M2Integration\Observer\Newsletter;

use Samba\M2Integration\Helper\ExportHelper;
use Magento\Customer\Model\Session;
use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;

class NewsletterSubscriberSaveAfter implements ObserverInterface
{
    /** @var Session */
    protected $customerSession;

    /** @var ExportHelper */
    protected $exportHelper;

    /**
     * @param Session $customerSession
     * @param ExportHelper $exportHelper
     */
    public function __construct(
        Session $customerSession,
        ExportHelper $exportHelper
    ) {
        $this->customerSession = $customerSession;
        $this->exportHelper = $exportHelper;
    }

    /**
     * @param Observer $observer
     * @return void
     */
    public function execute(Observer $observer): void
    {
        $subscriber = $observer->getEvent()->getSubscriber();
        $email = $subscriber->getEmail();

        $this->customerSession->setNewsletterEmail($email);
    }
}
