<?php
namespace Samba\M2Integration\Model;

use Magento\Framework\ObjectManagerInterface;

class QueueFactory
{
    /**
     * @var ObjectManagerInterface
     */
    private $objectManager;

    /**
     * @var string
     */
    private $instanceName;

    public function __construct(
        ObjectManagerInterface $objectManager,
        string $instanceName = Queue::class
    ) {
        $this->objectManager = $objectManager;
        $this->instanceName = $instanceName;
    }

    public function create(array $data = []): Queue
    {
        return $this->objectManager->create($this->instanceName, ['data' => $data]);
    }
}
