<?php

declare(strict_types=1);

namespace Samba\M2Integration\Model;

use Magento\Framework\App\Filesystem\DirectoryList;
use Magento\Framework\Filesystem;
use Magento\Framework\Filesystem\File\WriteInterface;

class FileWriter
{

    /** @var DirectoryList */
    private $directoryList;

    /** @var Filesystem */
    private $filesystem;

    public function __construct(
        DirectoryList $directoryList,
        Filesystem $filesystem
    ) {
        $this->directoryList = $directoryList;
        $this->filesystem = $filesystem;
    }

    public function openFile(string $fileName): WriteInterface
    {
        $writeDirectory = $this->filesystem->getDirectoryWrite(
            DirectoryList::VAR_DIR
        );
        $varPath = $this->directoryList->getPath('var');
        $path = $varPath . '/feed/' . $fileName;

        $stream = $writeDirectory->openFile($path, 'w+');
        $stream->lock();
        return $stream;
    }

    /**
     * @param WriteInterface $stream
     * @return void
     */
    public function closeFile(WriteInterface $stream): void
    {
        $stream->unlock();
        $stream->close();
    }
}
