<?php

declare(strict_types=1);

namespace Samba\M2Integration\Model\FeedGenerator;

use Samba\M2Integration\Helper\ExportHelper;
use Magento\Catalog\Model\ResourceModel\Category\CollectionFactory;
use Samba\M2Integration\Model\FeedGeneratorInterface;
use Samba\M2Integration\Model\FileWriter;

class Categories implements FeedGeneratorInterface
{
    /** @var CollectionFactory */
    private $categoryCollectionFactory;

    /** @var ExportHelper */
    private $exportHelper;

    /** @var FileWriter */
    private $fileWriter;

    /** @var array */
    private $usedCategories = [];

    /**
     * @param CollectionFactory $categoryCollectionFactory
     * @param ExportHelper $exportHelper
     * @param FileWriter $fileWriter
     */
    public function __construct(
        CollectionFactory $categoryCollectionFactory,
        ExportHelper $exportHelper,
        FileWriter $fileWriter
    ) {
        $this->categoryCollectionFactory = $categoryCollectionFactory;
        $this->exportHelper = $exportHelper;
        $this->fileWriter = $fileWriter;
    }

    public function generateFeed(): void
    {
        $stream = $this->fileWriter->openFile(ExportHelper::CATEGORIES_FILE);

        $xmlWriter = new \XMLWriter();
        $xmlWriter->openMemory();
        $xmlWriter->setIndent(true);
        $xmlWriter->startDocument('1.0', 'UTF-8');
        $xmlWriter->startElement('CATEGORY');

        $storeId = $this->exportHelper->getStoreId();

        $collection = $this->categoryCollectionFactory->create();
        $collection->addAttributeToSelect("*")
            ->addIsActiveFilter()
            ->setStoreId($storeId);

        foreach ($collection as $c) {
            if (!in_array($c->getId(), $this->usedCategories)) {
                $xmlWriter->startElement('ITEM');
                $xmlWriter->writeElement('TITLE', $c->getName());
                $xmlWriter->writeElement('URL', $c->getUrl());

                $this->usedCategories[] = $c->getId();
                $this->addSubCategory($c, $xmlWriter);
                $xmlWriter->endElement();
            }
        }

        $xmlWriter->endElement();

        $stream->write((string)$xmlWriter->flush(true));
        $this->fileWriter->closeFile($stream);
    }

    protected function addSubCategory($category, $xmlWriter)
    {
        if (count($cats = $category->getChildrenCategories()) > 0) {
            foreach ($cats as $cat) {
                $xmlWriter->startElement('ITEM');
                $xmlWriter->writeElement('TITLE', $cat->getName());
                $xmlWriter->writeElement('URL', $cat->getUrl());

                $this->usedCategories[] = $cat->getId();
                $this->addSubCategory($cat, $xmlWriter);

                $xmlWriter->endElement();
            }
        }
    }
}
