<?php

declare(strict_types=1);

namespace Samba\M2Integration\Model\Config\Source;

use Magento\Framework\Data\OptionSourceInterface;
use Magento\Store\Api\StoreRepositoryInterface;

class StoreList implements OptionSourceInterface
{
    /** @var StoreRepositoryInterface */
    protected $storeRepository;

    /**
     * @param StoreRepositoryInterface $storeRepository
     */
    public function __construct(
        StoreRepositoryInterface $storeRepository
    ) {
        $this->storeRepository = $storeRepository;
    }

    public function toOptionArray(): array
    {
        return $this->getStoreList();
    }

    public function getStoreList(): array
    {
        $storeList = $this->storeRepository->getList();
        $options = [];

        foreach ($storeList as $store) {
            if ($store->getStoreId() == 0) {
                continue;
            }

            $options[] = [
                'value' => $store->getStoreId(),
                'label' => __($store->getName())
            ];
        }

        return $options;
    }
}
