<?php

declare(strict_types=1);

namespace Samba\M2Integration\Helper;

use Magento\Framework\App\Helper\AbstractHelper;
use Magento\Framework\App\Helper\Context;
use Magento\Framework\Stdlib\DateTime\TimezoneInterface;

class ExportHelper extends AbstractHelper
{
    const CUSTOMERS_FILE = 'feed_customers.xml';
    const PRODUCTS_FILE = 'feed_products.xml';
    const ORDERS_FILE = 'feed_orders.xml';
    const CATEGORIES_FILE = 'feed_categories.xml';

    const GENERATE_ENABLE = 'samba_config/settings/enable';
    const SMARTPOINT_KEY = 'samba_config/settings/smartpoint_id';
    const SMARTPOINT_SCRIPT = 'samba_config/settings/smartpoint_script';
    const ACCESS_KEY = 'samba_config/settings/access_key';
    const STORE_ID = 'samba_config/settings/store_id';

    /** @var TimezoneInterface */
    protected $timezoneInterface;

    /**
     * @param Context $context
     * @param TimezoneInterface $timezoneInterface
     */
    public function __construct(
        Context $context,
        TimezoneInterface $timezoneInterface
    ) {
        $this->timezoneInterface = $timezoneInterface;

        parent::__construct($context);
    }

    public function dateFormat($createdAt, $dateFormat = 'Y-m-d\TH:i:s.uP')
    {
        return $this->timezoneInterface->date(strtotime($createdAt))->format($dateFormat);
    }

    public function checkGenerateStatus()
    {
        return $this->scopeConfig->getValue(self::GENERATE_ENABLE);
    }

    public function checkSmartPointScript()
    {
        $smartPointKey = $this->scopeConfig->getValue(self::SMARTPOINT_KEY);
        $smartPointScript = $this->scopeConfig->getValue(self::SMARTPOINT_SCRIPT);

        if (isset($smartPointKey) && isset($smartPointScript)) {
            if ((bool)$smartPointScript) {
                return $smartPointKey;
            }
        }

        return null;
    }

    public function getAccessKey()
    {
        return $this->scopeConfig->getValue(self::ACCESS_KEY);
    }

    public function getStoreId()
    {
        return $this->scopeConfig->getValue(self::STORE_ID);
    }

    public function getConfig($path)
    {
        return $this->scopeConfig->getValue($path);
    }
}
