<?php

declare(strict_types=1);

namespace Samba\M2Integration\Helper;

use Magento\Checkout\Model\Session as CheckoutSession;
use Magento\Customer\Model\Session;

class DataHelper
{
    /** @var Session */
    protected $customerSession;
    /** @var CheckoutSession */
    protected $checkoutSession;

    /**
     * @param Session $customerSession
     * @param CheckoutSession $checkoutSession
     */
    public function __construct(
        Session $customerSession,
        CheckoutSession $checkoutSession
    ) {
        $this->customerSession = $customerSession;
        $this->checkoutSession = $checkoutSession;
    }

    /**
     * @return Session
     */
    public function getSessionCheckoutManager()
    {
        return $this->checkoutSession;
    }

    /**
     * @return Session
     */
    public function getSessionCustomerManager()
    {
        return $this->checkoutSession;
    }

}
