<?php

declare(strict_types=1);

namespace Samba\M2Integration\Cron;

use Psr\Log\LoggerInterface;
use Samba\M2Integration\Helper\ExportHelper;
use Samba\M2Integration\Model\FeedGeneratorInterface;
use Samba\M2Integration\Plugin\DisableSnapshotPlugin;

class FeedGenerator
{
    /** @var FeedGeneratorInterface */
    protected $feedGenerator;

    /** @var ExportHelper */
    protected $exportHelper;

    /** @var LoggerInterface */
    protected $logger;

    /**
     * @param FeedGeneratorInterface $feedGenerator
     * @param ExportHelper $exportHelper
     * @param LoggerInterface $logger
     */
    public function __construct(
        FeedGeneratorInterface $feedGenerator,
        ExportHelper $exportHelper,
        LoggerInterface $logger
    ) {
        $this->feedGenerator = $feedGenerator;
        $this->exportHelper = $exportHelper;
        $this->logger = $logger;
    }

    public function execute(): void
    {
        if ($this->exportHelper->checkGenerateStatus()) {
            DisableSnapshotPlugin::disable();
            $this->logger->info("Feed exporting started.", ['type' => get_class($this->feedGenerator)]);
            $this->feedGenerator->generateFeed();
            $this->logger->info("Feed has exported.", ['type' => get_class($this->feedGenerator)]);
            DisableSnapshotPlugin::enable();
        }
    }
}

