<?php

declare(strict_types=1);

namespace Samba\M2Integration\Controller\Index;

use Magento\Checkout\Model\Session as CheckoutSession;
use Magento\Customer\Model\SessionFactory;
use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;
use Magento\Framework\App\Http\Context as AuthContext;
use Magento\Framework\Controller\ResultFactory;
use Samba\M2Integration\Helper\DataHelper;

class SmartPointBody extends Action
{
    /** @var DataHelper */
    protected $dataHelper;
    /** @var AuthContext */
    protected $authContext;
    /** @var SessionFactory */
    protected $customerSession;
    /** @var CheckoutSession */
    protected $checkoutSession;

    /**
     * @param Context $context
     * @param DataHelper $dataHelper
     * @param AuthContext $authContext
     * @param SessionFactory $customerSession
     * @param CheckoutSession $checkoutSession
     */
    public function __construct(
        Context $context,
        DataHelper $dataHelper,
        AuthContext $authContext,
        SessionFactory $customerSession,
        CheckoutSession $checkoutSession
    ) {
        $this->dataHelper = $dataHelper;
        $this->authContext = $authContext;
        $this->customerSession = $customerSession;
        $this->checkoutSession = $checkoutSession;
        parent::__construct($context);
    }

    /**
     * Execute view action
     *
     * @return \Magento\Framework\Controller\ResultInterface
     */
    public function execute()
    {
        $scripts = '';

        if (!empty($this->isLoggedIn())) {
            $customerId = $this->isLoggedIn();

            if (!empty($customerId)) {
                $scripts .= "diffAnalytics.customerLoggedIn('$customerId');";
            }
        }

        if (!empty($this->getEventOrderData())) {
            $orderItems = $this->getEventOrderData();

            if (!empty($orderItems)) {
                $scripts .= "diffAnalytics.order({ content: $orderItems });diffAnalytics.cartInteraction({ content: [] });";
                $this->removeOrderData();
            }
        }

        if (!empty($this->getCartData())) {
            $cartItems = $this->getCartData();

            if (!empty($cartItems)) {
                $scripts .= "diffAnalytics.cartInteraction({ content: $cartItems });";
            }
        }

        if ($scripts != '') {
            $script = "<script>$scripts</script>";
        } else {
            $script = '';
        }

        $resultJson = $this->resultFactory->create(ResultFactory::TYPE_JSON);
        return $resultJson->setData($script);
    }

    public function isLoggedIn()
    {
        $isLoggedIn = $this->authContext->getValue(\Magento\Customer\Model\Context::CONTEXT_AUTH);
        if ($isLoggedIn) {
            return $this->customerSession->create()->getCustomer()->getId();
        }
        return null;
    }

    public function getEventOrderData()
    {
        $data = [];

        if (!empty($this->dataHelper->getSessionCheckoutManager()->getOrderData())) {
            $data = $this->dataHelper->getSessionCheckoutManager()->getOrderData();

            return json_encode($data);
        }
        return null;
    }

    public function removeOrderData()
    {
        $this->dataHelper->getSessionCheckoutManager()->setOrderData(null);
    }

    public function getCartData()
    {
        $data = [];

        if ($this->checkoutSession->getQuote()->getAllVisibleItems() != null) {
            $items = $this->checkoutSession->getQuote()->getAllVisibleItems();

            foreach ($items as $item) {
                $data[] = (object)[
                    "productId" => $item->getProductId(),
                    "amount" => $item->getQty()
                ];
            }

            return json_encode($data);
        }
        return null;
    }
}
