<?php

declare(strict_types=1);

namespace Samba\M2Integration\Controller\Index;

use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;
use Magento\Framework\Controller\ResultFactory;
use Samba\M2Integration\Helper\ExportHelper;

class SmartPoint extends Action
{
    /** @var ExportHelper */
    protected $exportHelper;

    /**
     * @param Context $context
     * @param ExportHelper $exportHelper
     */
    public function __construct(
        Context $context,
        ExportHelper $exportHelper
    ) {
        $this->exportHelper = $exportHelper;
        parent::__construct($context);
    }

    /**
     * Execute view action
     *
     * @return \Magento\Framework\Controller\ResultInterface
     */
    public function execute()
    {
        $script = '';

        if (!empty($this->isEnableSmartPoint())) {

            $smartPointKey = $this->isEnableSmartPoint();

            if (!empty($smartPointKey)) {

                $script =  '
                <script async src="https://yottlyscript.com/script.js?tp='. $smartPointKey .'"></script>
                <script async src="https://yottlyscript.com/push/service-worker.js?tp='. $smartPointKey .'"></script>
                ';

            }

        }

        $resultJson = $this->resultFactory->create(ResultFactory::TYPE_JSON);
        return $resultJson->setData($script);
    }

    public function isEnableSmartPoint()
    {
        if(($smartPointKey = $this->exportHelper->checkSmartPointScript()) != null) {
            return $smartPointKey;
        }
        return null;
    }

}
