<?php

declare(strict_types=1);

namespace Samba\M2Integration\Controller\Index;

use Magento\Customer\Model\Session;
use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;
use Magento\Framework\Controller\ResultFactory;
use Magento\Framework\Controller\ResultInterface;

class Newsletter extends Action
{
    /** @var Session */
    protected $customerSession;

    /**
     * @param Context $context
     * @param Session $customerSession
     */
    public function __construct(
        Context $context,
        Session $customerSession
    ) {
        $this->customerSession = $customerSession;
        parent::__construct($context);
    }

    /**
     * @return ResultInterface
     */
    public function execute(): ResultInterface
    {
        $resultJson = $this->resultFactory->create(ResultFactory::TYPE_JSON);
        return $resultJson->setData($this->getNewsletterEmail());
    }

    public function getNewsletterEmail()
    {
        $data = $this->customerSession->getNewsletterEmail();
        $this->customerSession->unsNewsletterEmail();

        return isset($data) ?? '';
    }
}
