<?php

declare(strict_types=1);

namespace Samba\M2Integration\Controller\Index;

use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;
use Magento\Framework\App\Filesystem\DirectoryList;
use Magento\Framework\Module\Dir;
use Samba\M2Integration\Helper\ExportHelper;

class Index extends Action
{
    /** @var Dir */
    protected $moduleDir;

    /** @var ExportHelper */
    protected $exportHelper;

    /** @var DirectoryList */
    private $directoryList;

    private $key;

    private $feedName;

    /**
     * @param Context $context
     * @param Dir $moduleDir
     * @param ExportHelper $exportHelper
     * @param DirectoryList $directoryList
     */
    public function __construct(
        Context $context,
        Dir $moduleDir,
        ExportHelper $exportHelper,
        DirectoryList $directoryList
    ) {
        $this->moduleDir = $moduleDir;
        $this->exportHelper = $exportHelper;
        $this->directoryList = $directoryList;

        parent::__construct($context);
    }

    /**
     * Execute view action
     *
     * @return \Magento\Framework\Controller\ResultInterface
     */
    public function execute()
    {
        if (!$this->validateAccess()) {
            return;
        }

        header('Content-Type: text/xml');

        try {
            switch ($this->feedName) {
                case "customers":
                    $this->loadXML(ExportHelper::CUSTOMERS_FILE);
                    break;
                case "products":
                    $this->loadXML(ExportHelper::PRODUCTS_FILE);
                    break;
                case "orders":
                    $this->loadXML(ExportHelper::ORDERS_FILE);
                    break;
                case "categories":
                    $this->loadXML(ExportHelper::CATEGORIES_FILE);
                    break;
            }
        } catch (\Exception $e) {
            echo "<html><body>An unexpected error has occurred</body></html>";
            http_response_code(403);
            return;
        }
    }

    private function validateAccess()
    {
        $params = $this->_request->getParams();

        if (!isset($params['key']) || !isset($params['feed'])) {
            echo "<html><body>Access denied.</body></html>";
            http_response_code(403);
            return false;
        }

        $this->key = $params['key'];
        $this->feedName = $params['feed'];

        if ($this->key != $this->exportHelper->getAccessKey()) {
            echo "<html><body>Wrong key, access denied.</body></html>";
            http_response_code(403);
            return false;
        }

        return true;
    }

    private function loadXML($fileName)
    {
        $varPath = $this->directoryList->getPath('var');
        $path = $varPath . '/feed/' . $fileName;

        if (is_file($path)) {
            $xml = simplexml_load_file($path);
            echo $xml->asXML();
        } else {
            echo "<html><body>Feed not yet generated.</body></html>";
            http_response_code(403);
        }
    }
}
