<?php

declare(strict_types=1);

namespace Samba\M2Integration\Block;

use Magento\Backend\Block\Template\Context;
use Magento\Framework\Data\Form\Element\AbstractElement;
use Magento\Config\Block\System\Config\Form\Field;

use Magento\Store\Model\StoreManagerInterface;
use Samba\M2Integration\Helper\ExportHelper;

class FeedLinks extends Field
{
    /** @var StoreManagerInterface */
    protected $storeManager;

    /** @var ExportHelper */
    protected $exportHelper;

    /**
     * @param Context $context
     * @param StoreManagerInterface $storeManager
     * @param ExportHelper $exportHelper
     * @param array $data
     */
    public function __construct(
        Context $context,
        StoreManagerInterface $storeManager,
        ExportHelper $exportHelper,
        array $data = []
    ) {
        $this->storeManager = $storeManager;
        $this->exportHelper = $exportHelper;
        parent::__construct($context, $data);
    }

    /**
     * Retrieve Element HTML fragment
     *
     * @param AbstractElement $element
     * @return string
     */
    protected function _getElementHtml(AbstractElement $element): string
    {
        $html = '<div>'
            . '<input value="' . $this->storeManager->getStore()->getBaseUrl(
            ) . 'samba/index/index/key/' . $this->exportHelper->getAccessKey(
            ) . '/feed/products' . '" class="input-text admin__control-text" type="text"><p class="note"><span>Products</span></p>'
            . '<input value="' . $this->storeManager->getStore()->getBaseUrl(
            ) . 'samba/index/index/key/' . $this->exportHelper->getAccessKey(
            ) . '/feed/customers' . '" class="input-text admin__control-text" type="text"><p class="note"><span>Customers</span></p>'
            . '<input value="' . $this->storeManager->getStore()->getBaseUrl(
            ) . 'samba/index/index/key/' . $this->exportHelper->getAccessKey(
            ) . '/feed/orders' . '" class="input-text admin__control-text" type="text"><p class="note"><span>Orders</span></p>'
            . '<input value="' . $this->storeManager->getStore()->getBaseUrl(
            ) . 'samba/index/index/key/' . $this->exportHelper->getAccessKey(
            ) . '/feed/categories' . '" class="input-text admin__control-text" type="text"><p class="note"><span>Categories</span></p></div>';

        return $html;
    }
}
