<?php
declare(strict_types=1);

namespace Samba\M2Integration\Api\Data;

interface QueueInterface
{

    const TYPE = 'type';
    const EXECUTED_AT = 'executed_at';
    const QUEUE_ID = 'queue_id';
    const MESSAGE = 'message';
    const STATUS = 'status';
    const SCHEDULED_AT = 'scheduled_at';

    /**
     * Get queue_id
     * @return string|null
     */
    public function getQueueId();

    /**
     * Set queue_id
     * @param string $queueId
     * @return \Samba\M2Integration\Queue\Api\Data\QueueInterface
     */
    public function setQueueId($queueId);

    /**
     * Get type
     * @return string|null
     */
    public function getType();

    /**
     * Set type
     * @param string $type
     * @return \Samba\M2Integration\Queue\Api\Data\QueueInterface
     */
    public function setType($type);

    /**
     * Get status
     * @return string|null
     */
    public function getStatus();

    /**
     * Set status
     * @param string $status
     * @return \Samba\M2Integration\Queue\Api\Data\QueueInterface
     */
    public function setStatus($status);

    /**
     * Get scheduled_at
     * @return string|null
     */
    public function getScheduledAt();

    /**
     * Set scheduled_at
     * @param string $scheduledAt
     * @return \Samba\M2Integration\Queue\Api\Data\QueueInterface
     */
    public function setScheduledAt($scheduledAt);

    /**
     * Get executed_at
     * @return string|null
     */
    public function getExecutedAt();

    /**
     * Set executed_at
     * @param string $executedAt
     * @return \Samba\M2Integration\Queue\Api\Data\QueueInterface
     */
    public function setExecutedAt($executedAt);

    /**
     * Get message
     * @return string|null
     */
    public function getMessage();

    /**
     * Set message
     * @param string $message
     * @return \Samba\M2Integration\Queue\Api\Data\QueueInterface
     */
    public function setMessage($message);
}

